# Configuration settings for the Run-AutoKape.ps1, Prepare-AutoKapeServer.ps1, and Restore-AutoKapeServer.ps1 scripts
@{
    # An array of target computers to be processed, which must maintain the following array syntax:
    # TargetComputers = @('Computer1', 'Computer2', 'Computer3')
    TargetComputers = @('Computer1', 'Computer2', 'Computer3')

    # The username for the server, replace with a unique name for the temporary user account
    ServerUserName = 'username'

    # The password for the server user
    # If you prefer, comment out the line below and you will be prompted for the password when the script is run
    ServerUserPassword = 'Replace_this.With_4.Un1que.Password!'

    # The IP address of the server
    ServerIPAddress = '192.168.1.1'

    # The subnet mask of the server in CIDR notation
    ServerSubnetMask = 24

    # The primary DNS server to be used
    DNSServer1 = '8.8.8.8'

    # The secondary DNS server to be used
    DNSServer2 = '1.1.1.1'

    #The default gateway for this network
    DefaultGateway = '192.168.138.2'

    # The local path on the server where Kape.exe and associated files are stored
    KapeExePath = 'E:\TESTINGSHARE\kape'

    # The name to use for the share where the Kape exe and associated files can be accessed over the network
    KapeExeSharedFolderName = 'ExeShare'

    # The local path on the server where the output should be stored
    DestinationPath = 'E:\TESTINGSHARE\output'

    # The name to use for the share where the output can be accessed over the network
    DestinationSharedFolderName = 'DestinationShare'

    # The name of the interface to be configured on the server
    InterfaceName = 'Testing'
    
    # The path to the location where the transcript file will be created
    ServerTranscriptPath = '.'

    # The base name of the transcript file, a timestamp will be appended to the end
    ServerTranscriptName = 'SetupTranscript'

    # The path to the location where the transcript file will be created
    RunTranscriptPath = '.'

    # The base name of the transcript file, a timestamp will be appended to the end 
    RunTranscriptName = 'RunTranscript'

    # The arguments to be passed to Kape
    KapeArguments = "--tsource C: --tdest `$DestinationShare\%m --tflush --vhdx %m --zv True --target !SANS_Triage"

}